/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable;

import com.google.common.base.Suppliers;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.cache.AnimatableIdCache;
import software.bernie.geckolib.util.RenderUtils;

public interface GeoItem
extends SingletonGeoAnimatable {
    public static final String ID_NBT_KEY = "GeckoLibID";

    public static Supplier<Object> makeRenderer(GeoItem item) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return () -> null;
        }
        return Suppliers.memoize(() -> {
            AtomicReference renderProvider = new AtomicReference();
            item.createRenderer(renderProvider::set);
            return renderProvider.get();
        });
    }

    public static long getId(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return Long.MAX_VALUE;
        }
        return tag.method_10537(ID_NBT_KEY);
    }

    public static long getOrAssignId(class_1799 stack, class_3218 level) {
        class_2487 tag = stack.method_7948();
        long id = tag.method_10537(ID_NBT_KEY);
        if (tag.method_10573(ID_NBT_KEY, 99)) {
            return id;
        }
        id = AnimatableIdCache.getFreeId(level);
        tag.method_10544(ID_NBT_KEY, id);
        return id;
    }

    @Override
    default public double getTick(Object itemStack) {
        return RenderUtils.getCurrentTick();
    }
}

